#include <PalmOS.h>
#include "PowerReg.h"




Err PowerRegLibOpen(UInt16* ref){
	
	Err e;
	
	e=SysLibLoad(PowerRegType,PowerRegCreator,ref);
	
	return e;
}

void PowerRegLibClose(UInt16 ref){
	
	SysLibRemove(ref);
}



void msg(char* x){
	
	FrmCustomAlert(10024,x,NULL,NULL);
	
}

void msgN(char* x,UInt32 n){
	
	char y[16];
	
	StrIToA(y,n);
	
	FrmCustomAlert(10024,x,y,NULL);
	
}

void msgH(char* x,UInt32 n){
	
	char y[9];
	
	StrIToH(y,n);
	
	FrmCustomAlert(10024,x,y,NULL);
	
}

void err(char* x){
	
	ErrAlertCustom(0,x,NULL,NULL);
	
}


void errH(char* x,UInt32 n){
	
	char y[9];
	
	StrIToH(y,n);
	
	ErrAlertCustom(0,y,x,NULL);
	
}

/*
Err prGetRecordSize(UInt32 creator,UInt32 id,UInt32 key,UInt32* size)				//return record size if it exists and key is right
Err prGetRecordData(UInt32 creator,UInt32 id,UInt32 key,void* buffer)				//return record data if it exixts and key is right
Err prSetRecordData(UInt32 creator,UInt32 id,UInt32 key,void* buffer,UInt32 size)	//save record, do nothing if already exists
Err prSetRecordKey(UInt32 creator,UInt32 id,UInt32 oldKey,UInt32 newKey)			//change the key
Err prDeleteRecord(UInt32 creator,UInt32 id,UInt32 key)								//delete a record
*/


#define MY_KEY		0xABADC0DA		//hehe
#define MY_CREATOR	'TEST'

void test(UInt16 ref){
	
	Err e;
	UInt32 sz;
	UInt32 tmp;
	
	
	e=prGetRecordSize(ref,MY_CREATOR,0,0,&sz);
	
	if(e==errNone){					//we expect an error here because record ('TEST',0) does not exist
		
		err("test 1 failed!");
		
	}
	
	e=prGetRecordSize(ref,MY_CREATOR,1,MY_KEY,&sz);
	
	if(e==dmErrCantFind){		//does not exist yet - create
		
		tmp=TimGetSeconds();
		
		e=prSetRecordData(ref,MY_CREATOR,1,MY_KEY,&tmp,sizeof(UInt32));
		
		if(e){
			
			errH("Unexpected error creating resource 1 Err=0x",e);
			
		}
		
		tmp=1;
		
		e=prSetRecordData(ref,MY_CREATOR,2,MY_KEY,&tmp,sizeof(UInt32));
		
		if(e){
			
			errH("Unexpected error creating resource 2 Err=0x",e);
			
		}
		
		msg("This is the first time you ran this app");
	}
	else{
		
		UInt32 time;
		UInt32 num;
		
		
		if(sz!=sizeof(UInt32)){
			
			err("Size is not 4. this shoulnd't happen");
			
		}
		
		e=prGetRecordData(ref,MY_CREATOR,1,'haha',&time);		//try access with bad key
		
		if(e){
			
			msgH("As expected we got error while accessing with bad key. err=0x",e);
			
		}
		else{
			
			err("We should have gotten an error here (getting resource with bad key), but we did not. This shouldn't happen");
			
		}
		
		e=prGetRecordData(ref,MY_CREATOR,1,MY_KEY,&time);
		
		
		if(e){
			
			errH("We shouldn't have gotten an error here(getting data using correct key), but we did err=0x",e);
			
		}
		
		
		prGetRecordData(ref,MY_CREATOR,2,MY_KEY,&num);
		num++;
		e=prDeleteRecord(ref,MY_CREATOR,2,MY_KEY);
		
		if(e){
			
			errH("Unexpected error deleting resource 2 Err=0x",e);
			
		}
		
		e=prSetRecordData(ref,MY_CREATOR,2,MY_KEY,&num,sizeof(UInt32));
		
		if(e){
			
			errH("Unexpected error re-creating resource 2 Err=0x",e);
			
		}
		
		
		
		msgN("This is not the first time you ran this app, in fact this is time # ",num);
		msgN("The first time you ran this app was this many seconds ago:",TimGetSeconds()-time);
		
		
		
		//now try delete a non-existing record
		
		e=prDeleteRecord(ref,MY_CREATOR,0,0);
		
		if(e){
			
			msgH("As expected we got error while deleting non-existent record. err=0x",e);
			
		}
		else{
			
			err("We should have gotten an error here (deleting non-existent record), but we did not. This shouldn't happen");
			
		}
		
		//now try delete a existing record but with a bad key
		
		e=prDeleteRecord(ref,MY_CREATOR,1,'HAHA');
		
		if(e){
			
			msgH("As expected we got error while deleting existent record with a bad key. err=0x",e);
			
		}
		else{
			
			err("We should have gotten an error here(deleting a record with a bad key), but we did not. This shouldn't happen");
			
		}
		
		prSetRecordData(ref,MY_CREATOR,5,MY_KEY,NULL,0);		//create a record (yes it is zero sized)
		
		e=prSetRecordKey(ref,MY_CREATOR,5,'HAHA','1234');		//try changing key using bad "oldKey" param
		
		if(e){
			
			msgH("As expected we got error while changing record key with a bad original key. err=0x",e);
			
		}
		else{
			
			err("We should have gotten an error here(setting key using bad original key), but we did not. This shouldn't happen");
			
		}
		
		e=prSetRecordKey(ref,MY_CREATOR,5,MY_KEY,'1234');		//now this record's key is '1234'
		
		if(e){
			
			errH("We shouldn't have gotten an error here (setting key using correct old key), but we did err=0x",e);
			
		}
		
		e=prDeleteRecord(ref,MY_CREATOR,5,'1234');
		
		if(e){
			
			errH("We shouldn't have gotten an error here (deteting a record using correct key), but we did err=0x",e);
			
		}
	}
}

void redLedLibTest(){
	
	UInt16 ref;
	Err e;
	
	
	//load the library
	
	e=PowerRegLibOpen(&ref);
	
	if(e){
		
		ErrAlertCustom(e,"Error occured while opening the library: ",NULL,NULL);
		return;
		
	}
	else{
		
		FrmCustomAlert(10024,"Library ","opened"," ok");
		
	}
	
	//test
	
	test(ref);
	
	PowerRegLibClose(ref);
}




UInt32 PilotMain(UInt16 cmd, MemPtr cmdPBP, UInt16 launchFlags)
{
	
	if(cmd==0){
		
		redLedLibTest();
		
		
	}
	
	return errNone;
}
